<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Candlestick Chart from JSON</h1>
<div id="chartContainer"></div>

<script>
    window.onload = function() {
        var dps = [];
        var chart = new CanvasJS.Chart("chartContainer", {
            zoomEnabled: true,
            exportEnabled: true,
            title: {
                text: "Qualcomm Incorporated Stock Price - 2017"
            },
            subtitles: [{
                text : "Try Zooming and Panning"
            }],
            axisX: {
                valueFormatString: "DD MMM"
            },
            axisY: {
                title: "Price",
                interval: 5,
                prefix: "$"
            },
            data: [{
                type: "candlestick",
                name: "Qualcomm Incorporated Stock Price",
                showInLegend: true,
                yValueFormatString: "$##0.00",
                xValueType: "dateTime",
                dataPoints: dps
            }]
        });
        
        $.getJSON("../data/qualcomm-stock-price.json", parseData);
        
        function parseData(result) {
            for (var i = 0; i < result.length; i++) {
                dps.push({
                    x: result[i].x,
                    y: result[i].y
                });
            }
            chart.render();
        }
    }
</script>

<?php include '../footer.php'; ?>